---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Google Analytics設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_admin.asp` - 基本設定画面（11行）
- E-02: `asp/bs_process.asp` - 処理分岐ロジック（214行）
- E-03: `asp/includes/customer.asp` - cls_customerクラス（1637行）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bSetupGeneral権限チェック | E-01（4行目） | ○ |
| C-02 | googleAnalytics項目がフォームに存在 | E-01（10行目: textarea name="googleAnalytics"） | ○ |
| C-03 | Google Analytics公式サイトへのリンクが存在 | E-01（10行目: href="http://www.google.com/analytics/"） | ○ |
| C-04 | saveAdmin処理でgoogleAnalytics取得 | E-02（115行目: customer.googleAnalytics = Request.Form） | ○ |
| C-05 | CSRF検証を実行 | E-02（104行目: checkCSRF） | ○ |
| C-06 | customer.save()でDB保存 | E-02（122行目） | ○ |
| C-07 | メニューキャッシュクリア | E-02（124行目: clearMenuCache） | ○ |
| C-08 | cls_customerにgoogleAnalyticsプロパティが存在 | E-03（8行目: Public googleAnalytics） | ○ |
| C-09 | save関数でgoogleAnalyticsを保存 | E-03（374行目: rs("googleAnalytics") = googleAnalytics） | ○ |
| C-10 | 関連画面No.86,136,137 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - GA設定処理が全てソースコードで確認済み
- 1: 中リスク - JavaScriptコードの直接記述が可能なため、XSS等のリスクを考慮する必要あり

## 6) レビュアーチェックリスト（最小）
- [ ] GAコードがフロントサイトに正しく出力されるか確認
- [ ] 悪意のあるスクリプト挿入に対する管理者権限の制御が適切か確認
- [ ] GA4形式のコードが正しく動作するか確認
